package jamezo97.clonecraft.entity.clone;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(value = RetentionPolicy.RUNTIME)
public @interface Value {
	
	int id();
	
	
	/**
	 * If wishing to send more than one value, IE, for experience, use sub ids to send them all in one packet.
	 * Use a new subId for each new value, incrementing by one from 0. Ensure the number doesn't exceed the actual
	 * amount of Value(s) annotation(s), otherwise you'll get a lovely error :)
	 * @return
	 */
	int subId() default 0;

}
